/*
 * Decompiled with CFR 0.152.
 */
package cds.healpix;

import cds.healpix.HealpixNestedBMOC;
import cds.healpix.Range;
import java.util.Iterator;

public class ToRangeItDecorator
implements Iterator<Range> {
    private final Iterator<HealpixNestedBMOC.CurrentValueAccessor> it;
    private Range current;
    private Range next;

    public ToRangeItDecorator(Iterator<HealpixNestedBMOC.CurrentValueAccessor> decorated) {
        this.it = decorated;
        if (this.it.hasNext()) {
            this.next = this.toRange(this.it.next());
        }
        this.nextRange();
    }

    @Override
    public void remove() {
    }

    private void nextRange() {
        Range r = null;
        while (this.it.hasNext() && this.tryMerge(this.next, r = this.toRange(this.it.next()))) {
            r = null;
        }
        this.current = this.next;
        this.next = r;
    }

    private Range toRange(HealpixNestedBMOC.CurrentValueAccessor cva) {
        int depth = cva.getDepth();
        long hash = cva.getHash();
        int ddTwice = 29 - depth << 1;
        return new Range(hash << ddTwice, hash + 1L << ddTwice);
    }

    private boolean tryMerge(Range left, Range right) {
        if (left.to == right.from) {
            left.to = right.to;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasNext() {
        return this.current != null;
    }

    @Override
    public Range next() {
        Range r = this.current;
        this.nextRange();
        return r;
    }
}

